/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.items;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.block.util.CapturedMobsHelper;
import net.mehvahdjukaar.supplementaries.common.capabilities.ICatchableMob;
import net.mehvahdjukaar.supplementaries.common.mobholder.MobContainer;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public abstract class AbstractMobContainerItem
extends BlockItem {
    private final float mobContainerHeight;
    private final float mobContainerWidth;
    private final boolean isAquarium;

    public AbstractMobContainerItem(Block block2, Item.Properties properties, float width, float height, boolean aquarium) {
        super(block2, properties);
        this.mobContainerWidth = width;
        this.mobContainerHeight = height;
        this.isAquarium = aquarium;
    }

    public float getMobContainerHeight() {
        return this.mobContainerHeight;
    }

    public float getMobContainerWidth() {
        return this.mobContainerWidth;
    }

    protected boolean canFitEntity(Entity e) {
        float margin = 0.125f;
        float h = e.func_213302_cg() - margin;
        float w = e.func_213311_cf() - margin;
        return w < this.mobContainerWidth && h < this.mobContainerHeight;
    }

    public void playCatchSound(PlayerEntity player) {
    }

    public void playFailSound(PlayerEntity player) {
    }

    public void playReleaseSound(World world, Vector3d v) {
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.isFull(stack) ? 1 : super.getItemStackLimit(stack);
    }

    public boolean isFull(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        return tag != null && tag.func_74764_b("BlockEntityTag");
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity entity2, Hand hand) {
        if (this.isFull(stack)) {
            return ActionResultType.PASS;
        }
        return this.doInteract(stack, player, (Entity)entity2, hand);
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity2) {
        if (this.isFull(stack)) {
            return false;
        }
        Hand hand = player.func_184600_cs();
        if (hand == null || hand == Hand.OFF_HAND) {
            return false;
        }
        return this.doInteract(stack, player, entity2, player.func_184600_cs()).func_226246_a_();
    }

    protected final boolean isEntityValid(Entity e, PlayerEntity player) {
        if (!e.func_70089_S() || e instanceof LivingEntity && ((LivingEntity)e).func_233643_dh_()) {
            return false;
        }
        if (e instanceof TameableEntity) {
            TameableEntity pet = (TameableEntity)e;
            return !pet.func_70909_n() || pet.func_152114_e((LivingEntity)player);
        }
        return true;
    }

    private <T extends Entity> boolean canCatch(T e) {
        String name = e.func_200600_R().getRegistryName().toString();
        if (ServerConfigs.cached.CAGE_ALL_MOBS || CapturedMobsHelper.COMMAND_MOBS.contains(name)) {
            return true;
        }
        ICatchableMob cap = MobContainer.getCap(e);
        return cap.canBeCaughtWithItem((Item)this);
    }

    public abstract boolean canItemCatch(Entity var1);

    public ItemStack captureEntityInItem(Entity entity2, ItemStack currentStack, ItemStack bucketStack) {
        CompoundNBT cmp;
        ItemStack returnStack = new ItemStack((IItemProvider)this);
        if (currentStack.func_82837_s()) {
            returnStack.func_200302_a(currentStack.func_200301_q());
        }
        if ((cmp = MobContainer.createMobHolderItemTag(entity2, this.getMobContainerWidth(), this.getMobContainerHeight(), bucketStack, this.isAquarium)) != null) {
            returnStack.func_77983_a("BlockEntityTag", (INBT)cmp);
        }
        return returnStack;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        CompoundNBT com = stack.func_179543_a("BlockEntityTag");
        PlayerEntity player = context.func_195999_j();
        if (!context.func_195999_j().func_225608_bj_() && com != null) {
            CompoundNBT nbt;
            Entity entity2;
            boolean success = false;
            World world = context.func_195991_k();
            Vector3d v = context.func_221532_j();
            if (com.func_74764_b("BucketHolder")) {
                ItemStack bucketStack = ItemStack.func_199557_a((CompoundNBT)com.func_74775_l("BucketHolder").func_74775_l("Bucket"));
                if (bucketStack.func_77973_b() instanceof BucketItem) {
                    ((BucketItem)bucketStack.func_77973_b()).func_203792_a(world, bucketStack, context.func_195995_a());
                    success = true;
                }
            } else if (com.func_74764_b("MobHolder") && (entity2 = EntityType.func_220335_a((CompoundNBT)(nbt = com.func_74775_l("MobHolder")).func_74775_l("EntityData"), (World)world, o -> o)) != null) {
                success = true;
                if (!world.field_72995_K) {
                    if (!player.func_184812_l_() && entity2 instanceof IAngerable) {
                        IAngerable ang = (IAngerable)entity2;
                        ang.func_241355_J__();
                        ang.func_230259_a_(player.func_110124_au());
                        ang.func_70604_c((LivingEntity)player);
                    }
                    entity2.func_70080_a(v.func_82615_a(), v.func_82617_b(), v.func_82616_c(), context.func_195990_h(), 0.0f);
                    UUID temp = entity2.func_110124_au();
                    if (nbt.func_74764_b("UUID")) {
                        UUID id = nbt.func_186857_a("UUID");
                        entity2.func_184221_a(id);
                    }
                    if (!world.func_217376_c(entity2)) {
                        entity2.func_184221_a(temp);
                        success = world.func_217376_c(entity2);
                        if (!success) {
                            Supplementaries.LOGGER.warn("Failed to release caged mob");
                        }
                    }
                }
                if (player.func_184812_l_() && nbt.func_74764_b("UUID")) {
                    nbt.func_186854_a("UUID", MathHelper.func_180182_a((Random)field_77697_d));
                }
            }
            if (success) {
                if (!world.field_72995_K) {
                    this.playReleaseSound(world, v);
                    if (!player.func_184812_l_()) {
                        ItemStack returnItem = new ItemStack((IItemProvider)this);
                        if (stack.func_82837_s()) {
                            returnItem.func_200302_a(stack.func_200301_q());
                        }
                        Utils.swapItemNBT((PlayerEntity)player, (Hand)context.func_221531_n(), (ItemStack)stack, (ItemStack)returnItem);
                    }
                }
                return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
            }
        }
        return super.func_195939_a(context);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT compoundnbt = stack.func_179543_a("BlockEntityTag");
        if (compoundnbt != null) {
            CompoundNBT com = compoundnbt.func_74775_l("MobHolder");
            if (com == null || com.isEmpty()) {
                com = compoundnbt.func_74775_l("BucketHolder");
            }
            if (com != null && com.func_74764_b("Name")) {
                tooltip.add((ITextComponent)new StringTextComponent(com.func_74779_i("Name")).func_240699_a_(TextFormatting.GRAY));
            }
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("message.supplementaries.cage").func_240699_a_(TextFormatting.ITALIC).func_240699_a_(TextFormatting.GRAY));
    }

    private void angerNearbyEntities(Entity entity2, PlayerEntity player) {
        if (entity2 instanceof IAngerable && entity2 instanceof MobEntity) {
            AbstractMobContainerItem.getEntitiesInRange((MobEntity)entity2).stream().filter(mob -> mob != entity2).map(mob -> (IAngerable)mob).forEach(mob -> {
                mob.func_241355_J__();
                mob.func_230259_a_(player.func_110124_au());
                mob.func_70604_c((LivingEntity)player);
            });
        }
        if (entity2 instanceof PiglinEntity) {
            entity2.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 0.0f);
        }
    }

    private static List<MobEntity> getEntitiesInRange(MobEntity e) {
        double d0 = e.func_233637_b_(Attributes.field_233819_b_);
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_241549_a_((Vector3d)e.func_213303_ch()).func_72314_b(d0, 10.0, d0);
        return e.field_70170_p.func_225317_b(e.getClass(), axisalignedbb);
    }

    public ActionResultType doInteract(ItemStack stack, PlayerEntity player, Entity entity2, Hand hand) {
        if (this.isEntityValid(entity2, player)) {
            ItemStack bucket = ItemStack.field_190927_a;
            if (entity2 instanceof WaterMobEntity && (this.isAquarium || this.canCatch(entity2))) {
                bucket = this.tryGettingFishBucket(player, entity2, hand);
            }
            if (!bucket.func_190926_b() || this.canCatch(entity2)) {
                entity2.revive();
                if (player.field_70170_p.field_72995_K) {
                    return ActionResultType.SUCCESS;
                }
                this.playCatchSound(player);
                this.angerNearbyEntities(entity2, player);
                Utils.swapItemNBT((PlayerEntity)player, (Hand)hand, (ItemStack)stack, (ItemStack)this.captureEntityInItem(entity2, stack, bucket));
                entity2.func_70106_y();
                return ActionResultType.CONSUME;
            }
        }
        this.playFailSound(player);
        return ActionResultType.PASS;
    }

    private ItemStack tryGettingFishBucket(PlayerEntity player, Entity entity2, Hand hand) {
        ItemStack filledBucket;
        ItemStack heldItem = player.func_184586_b(hand).func_77946_l();
        ItemStack bucket = ItemStack.field_190927_a;
        player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151131_as));
        ActionResultType result = entity2.func_184230_a(player, hand);
        if (!result.func_226246_a_()) {
            player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151133_ar));
            result = entity2.func_184230_a(player, hand);
        }
        if (result.func_226246_a_() && (filledBucket = player.func_184586_b(hand)) != heldItem && !entity2.func_70089_S()) {
            bucket = filledBucket;
        }
        player.func_184611_a(hand, heldItem);
        player.func_184598_c(hand);
        return bucket;
    }

    public ActionResultType func_195942_a(BlockItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player != null && player.func_225608_bj_()) {
            return super.func_195942_a(context);
        }
        return ActionResultType.PASS;
    }
}

